<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DiscoveryEngine\Resource;

use Google\Service\DiscoveryEngine\GoogleCloudDiscoveryengineV1betaDocument;
use Google\Service\DiscoveryEngine\GoogleCloudDiscoveryengineV1betaImportDocumentsRequest;
use Google\Service\DiscoveryEngine\GoogleCloudDiscoveryengineV1betaListDocumentsResponse;
use Google\Service\DiscoveryEngine\GoogleLongrunningOperation;
use Google\Service\DiscoveryEngine\GoogleProtobufEmpty;

/**
 * The "documents" collection of methods.
 * Typical usage is:
 *  <code>
 *   $discoveryengineService = new Google\Service\DiscoveryEngine(...);
 *   $documents = $discoveryengineService->projects_locations_dataStores_branches_documents;
 *  </code>
 */
class ProjectsLocationsDataStoresBranchesDocuments extends \Google\Service\Resource
{
  /**
   * Creates a Document. (documents.create)
   *
   * @param string $parent Required. The parent resource name, such as `projects/{
   * project}/locations/{location}/dataStores/{data_store}/branches/{branch}`.
   * @param GoogleCloudDiscoveryengineV1betaDocument $postBody
   * @param array $optParams Optional parameters.
   *
   * @opt_param string documentId Required. The ID to use for the Document, which
   * will become the final component of the Document.name. If the caller does not
   * have permission to create the Document, regardless of whether or not it
   * exists, a PERMISSION_DENIED error is returned. This field must be unique
   * among all Documents with the same parent. Otherwise, an ALREADY_EXISTS error
   * is returned. This field must conform to
   * [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit
   * of 63 characters. Otherwise, an INVALID_ARGUMENT error is returned.
   * @return GoogleCloudDiscoveryengineV1betaDocument
   */
  public function create($parent, GoogleCloudDiscoveryengineV1betaDocument $postBody, $optParams = [])
  {
    $params = ['parent' => $parent, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('create', [$params], GoogleCloudDiscoveryengineV1betaDocument::class);
  }
  /**
   * Deletes a Document. (documents.delete)
   *
   * @param string $name Required. Full resource name of Document, such as `projec
   * ts/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}/d
   * ocuments/{document}`. If the caller does not have permission to delete the
   * Document, regardless of whether or not it exists, a PERMISSION_DENIED error
   * is returned. If the Document to delete does not exist, a NOT_FOUND error is
   * returned.
   * @param array $optParams Optional parameters.
   * @return GoogleProtobufEmpty
   */
  public function delete($name, $optParams = [])
  {
    $params = ['name' => $name];
    $params = array_merge($params, $optParams);
    return $this->call('delete', [$params], GoogleProtobufEmpty::class);
  }
  /**
   * Gets a Document. (documents.get)
   *
   * @param string $name Required. Full resource name of Document, such as `projec
   * ts/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}/d
   * ocuments/{document}`. If the caller does not have permission to access the
   * Document, regardless of whether or not it exists, a PERMISSION_DENIED error
   * is returned. If the requested Document does not exist, a NOT_FOUND error is
   * returned.
   * @param array $optParams Optional parameters.
   * @return GoogleCloudDiscoveryengineV1betaDocument
   */
  public function get($name, $optParams = [])
  {
    $params = ['name' => $name];
    $params = array_merge($params, $optParams);
    return $this->call('get', [$params], GoogleCloudDiscoveryengineV1betaDocument::class);
  }
  /**
   * Bulk import of multiple Documents. Request processing may be synchronous.
   * Non-existing items will be created. Note: It is possible for a subset of the
   * Documents to be successfully updated. (documents.import)
   *
   * @param string $parent Required. The parent branch resource name, such as `pro
   * jects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch
   * }`. Requires create/update permission.
   * @param GoogleCloudDiscoveryengineV1betaImportDocumentsRequest $postBody
   * @param array $optParams Optional parameters.
   * @return GoogleLongrunningOperation
   */
  public function import($parent, GoogleCloudDiscoveryengineV1betaImportDocumentsRequest $postBody, $optParams = [])
  {
    $params = ['parent' => $parent, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('import', [$params], GoogleLongrunningOperation::class);
  }
  /**
   * Gets a list of Documents.
   * (documents.listProjectsLocationsDataStoresBranchesDocuments)
   *
   * @param string $parent Required. The parent branch resource name, such as `pro
   * jects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch
   * }`. Use `default_branch` as the branch ID, to list documents under the
   * default branch. If the caller does not have permission to list Documentss
   * under this branch, regardless of whether or not this branch exists, a
   * PERMISSION_DENIED error is returned.
   * @param array $optParams Optional parameters.
   *
   * @opt_param int pageSize Maximum number of Documents to return. If
   * unspecified, defaults to 100. The maximum allowed value is 1000. Values above
   * 1000 will be coerced to 1000. If this field is negative, an INVALID_ARGUMENT
   * error is returned.
   * @opt_param string pageToken A page token
   * ListDocumentsResponse.next_page_token, received from a previous
   * DocumentService.ListDocuments call. Provide this to retrieve the subsequent
   * page. When paginating, all other parameters provided to
   * DocumentService.ListDocuments must match the call that provided the page
   * token. Otherwise, an INVALID_ARGUMENT error is returned.
   * @return GoogleCloudDiscoveryengineV1betaListDocumentsResponse
   */
  public function listProjectsLocationsDataStoresBranchesDocuments($parent, $optParams = [])
  {
    $params = ['parent' => $parent];
    $params = array_merge($params, $optParams);
    return $this->call('list', [$params], GoogleCloudDiscoveryengineV1betaListDocumentsResponse::class);
  }
  /**
   * Updates a Document. (documents.patch)
   *
   * @param string $name Immutable. The full resource name of the document.
   * Format: `projects/{project}/locations/{location}/dataStores/{data_store}/bran
   * ches/{branch}/documents/{document_id}`. This field must be a UTF-8 encoded
   * string with a length limit of 1024 characters.
   * @param GoogleCloudDiscoveryengineV1betaDocument $postBody
   * @param array $optParams Optional parameters.
   *
   * @opt_param bool allowMissing If set to true, and the Document is not found, a
   * new Document will be created.
   * @return GoogleCloudDiscoveryengineV1betaDocument
   */
  public function patch($name, GoogleCloudDiscoveryengineV1betaDocument $postBody, $optParams = [])
  {
    $params = ['name' => $name, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('patch', [$params], GoogleCloudDiscoveryengineV1betaDocument::class);
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ProjectsLocationsDataStoresBranchesDocuments::class, 'Google_Service_DiscoveryEngine_Resource_ProjectsLocationsDataStoresBranchesDocuments');
